import javax.media.j3d.*;
import javax.vecmath.*; 
import java.awt.*;
import java.awt.event.*;
import com.sun.j3d.utils.geometry.*;
/**
 * This program uses AWT buttons to allow the user
 * to rotate an object.  This is achieved by altering
 * the transform of a transform group.
 * @author I.J.Palmer
 * @version 1.0
 */
public class SimpleTransform extends Frame implements ActionListener {
	protected Canvas3D myCanvas3D = new Canvas3D(null);
	/** The exit button */
	protected Button exitButton = new Button("Exit");
	/** The rotate left button */
	protected Button leftButton = new Button("<-");
	/** The rotate right button */
	protected Button rightButton = new Button("->");
	/** The transform group used to rotate the shape */
	protected TransformGroup rotationGroup;
    /**
     * This function builds the view branch of the scene
     * graph.  It creates a branch group and then creates the
     * necessary view elements to give a useful view of our
     * content.
     * @param c Canvas3D that will display the view
     * @return BranchGroup that is the root of the view elements
     */
	protected BranchGroup buildViewBranch(Canvas3D c) {
		BranchGroup viewBranch = new BranchGroup();
		Transform3D viewXfm = new Transform3D();
            	viewXfm.set(new Vector3f(0.0f,0.0f,10.0f));
		TransformGroup viewXfmGroup = new TransformGroup(viewXfm);
		ViewPlatform myViewPlatform = new ViewPlatform();
            	PhysicalBody myBody = new PhysicalBody();
            	PhysicalEnvironment myEnvironment = new PhysicalEnvironment();
		viewXfmGroup.addChild(myViewPlatform);
		viewBranch.addChild(viewXfmGroup);
		View myView = new View();
		myView.addCanvas3D(c);
		myView.attachViewPlatform(myViewPlatform);
            	myView.setPhysicalBody(myBody);
            	myView.setPhysicalEnvironment(myEnvironment);
		return viewBranch;
	}
    /**
     * Add some lights so that we can illuminate the scene.
     * This adds one ambient light to bring up the overall 
     * lighting level and one directional shape to show
     * the shape of the objects in the scene.
     * @param b BranchGroup that the lights are to be added to.
     */
      protected void addLights(BranchGroup b) {
            BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
		Color3f ambLightColour = new Color3f(0.5f, 0.5f, 0.5f);
		AmbientLight ambLight = new AmbientLight(ambLightColour);
            	ambLight.setInfluencingBounds(bounds);
            	Color3f dirLightColour = new Color3f(1.0f, 1.0f, 1.0f);
            	Vector3f dirLightDir  = new Vector3f(-1.0f, -1.0f, -1.0f);
            	DirectionalLight dirLight = new DirectionalLight(dirLightColour, dirLightDir);
            	dirLight.setInfluencingBounds(bounds);
		b.addChild(ambLight);
            	b.addChild(dirLight);
      }
    /**
     * This builds the content branch of our scene graph.
     * The root of the shapes supplied as a parameter
     * is slightly tilted to reveal its 3D shape. It also uses
     * the addLights function to add some lights to the scene.
     * The group that the shape is added to has its capabilities
     * set so that we can read and write it.
     * @param shape Node that represents the geometry for the content
     * @return BranchGroup that is the root of the content branch
     */
      protected BranchGroup buildContentBranch(Node shape) {
		BranchGroup contentBranch = new BranchGroup();
		Transform3D rotateCube = new Transform3D( );
            	rotateCube.set(new AxisAngle4d(1.0,1.0,0.0,Math.PI/4.0));
		rotationGroup = new TransformGroup(rotateCube);
		//Set the capabilities so that the transform can be accessed
		rotationGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		rotationGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		contentBranch.addChild(rotationGroup);
            	rotationGroup.addChild(shape);
            	addLights(contentBranch);
		return contentBranch;
      } 
    /** 
     * This defines the shapes used in the scene. It creates 
     * a simple cube using a Box utility class.
     * @return Node that is the root of the shape hierarchy.
     */
	protected Node buildShape() {
		Appearance app = new Appearance();
            	Color3f ambientColour = new Color3f(1.0f,0.0f,0.0f);
            	Color3f emissiveColour = new Color3f(0.0f,0.0f,0.0f);
		Color3f specularColour = new Color3f(1.0f,1.0f,1.0f);
            	Color3f diffuseColour = new Color3f(1.0f,0.0f,0.0f);
            	float shininess = 20.0f;
            	app.setMaterial(new Material(ambientColour,emissiveColour,
            			diffuseColour,specularColour,shininess));
		return new Box(2.0f, 2.0f, 2.0f, app);
	}
      /**
       * This processes the AWT events and performs the appropriate
       * operations.  The exit button causes the program to terminate,
       * the left button causes a rotation to be applied to the 
       * shape's transformation to spin it to the left and the right 
       * has the similar effect but to the right button.
       * @param e ActionEvent that has been performed
       */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == exitButton) {
			dispose();
                	System.exit(0);
		} else if (e.getSource() == leftButton) {
		    //Create a temporary transform
			Transform3D temp = new Transform3D();
			//Read the transform from the shape
			rotationGroup.getTransform(temp);
			//Create a rotation that will be applied
			Transform3D tempDelta = new Transform3D();
			tempDelta.rotY(-0.3);
			//Apply the rotation
			temp.mul(tempDelta);
			//Write the value back into the scene graph
			rotationGroup.setTransform(temp);
		} else if (e.getSource() == rightButton) {
		        //Do the same for the right rotation
			Transform3D temp = new Transform3D();
			rotationGroup.getTransform(temp);
			Transform3D tempDelta = new Transform3D();
			tempDelta.rotY(0.3);
			temp.mul(tempDelta);
			rotationGroup.setTransform(temp);
		}
	}
        public SimpleTransform() {
		VirtualUniverse myUniverse = new VirtualUniverse();
		Locale myLocale = new Locale(myUniverse);
                myLocale.addBranchGraph(buildViewBranch(myCanvas3D));
                myLocale.addBranchGraph(buildContentBranch(buildShape()));
		setTitle("SimpleWorld");
		setSize(400,400);
		setLayout(new BorderLayout());
		Panel bottom = new Panel();
		bottom.add(leftButton);
		bottom.add(rightButton);
		bottom.add(exitButton);
                add(BorderLayout.CENTER, myCanvas3D);
                add(BorderLayout.SOUTH, bottom);
                exitButton.addActionListener(this);
		leftButton.addActionListener(this);
		rightButton.addActionListener(this);
                setVisible(true);
	}
	public static void main(String[] args) {
                  SimpleTransform st = new SimpleTransform();
	}
}

